version 13 // indicates version
cls // clears backscroll display buffer
clear all // "start from scratch"
set more off // suppresses -more- prompts

/* load data */
cd "C:\Users\benja\Dropbox\BenjaminWork\ResearchProject\data\creation\data-sets and merge\big5\recode"
use "Big Five.dta" 

/* 
 Reduced (50-item) IPIP scale of the (100-item) Goldberg (1992) markers for the big-five factor structure.
 See Goldberg, L. R. (1992). The development of markers for the Big-Five factor structure. 
                             Psychological Assessment, 4, 26-42. 
							 
 Factor I: extraversion
           items 20 25 30 35 40 45 50 55 60 65
		   reversed coded: 25 35 45 55 65
		   
 Factor II: agreeableness
			items 21 26 31 36 41 46 51 56 61 66 
			reversed coded: 21 31 41 51 

 Factor III: conscientiousness
			 items 22 27 32 37 42 47 52 57 62 67
			 reversed coded: 27 37 47 57
 
 Factor IV: emotional stability
			items 23 28 33 38 43 48 53 58 63 68
			reversed coded: 23 33 43 48 53 58 63 68
			
 Factor V: imagination 
           items 24 29 34 39 44 49 54 59 64 69
		   reversed coded: 29 39 49
			
! Due to the recoding the labels of the reversed coded items are incorrect
! item numbers refer to the LISS variable names			
*/

/* check for no duplicate entries */
bys nomem_encr: gen N = _N
assert N == 1
drop N // no duplicate entries
// individuals are nested in households, but this is ignored here 

/* rename variables */
rename nomem_encr id

rename *cp08?(###)* .?(##)*
rename *cp09?(###)* .?(##)*
rename *cp10?(###)* .?(##)*
rename *cp11?(###)* .?(##)*
rename *cp12?(###)* .?(##)*
rename *cp13?(###)* .?(##)*
drop *cp14* // last wave has no observation

local k = 8
qui foreach letter in a b c d e f {
	// for each wave separately 
	local i = 1
	foreach j in 20 25 30 35 40 45 50 55 60 65 {
		// take these items and rename them ...
		rename `letter'`j' extraversion`i'`k'
		local i = `i' + 1
	}
	local i = 1 // countervariable has to be set to 1 each time
	foreach j in 21 26 31 36 41 46 51 56 61 66 {
		rename `letter'`j' agreeableness`i'`k'
		local i = `i' + 1
	}
	local i = 1
	foreach j in 22 27 32 37 42 47 52 57 62 67 {
		rename `letter'`j' conscientiousness`i'`k'
		local i = `i' + 1
	}
	local i = 1
	foreach j in 23 28 33 38 43 48 53 58 63 68 {
		rename `letter'`j' emostability`i'`k'
		local i = `i' + 1
	}
	local i = 1
	foreach j in 24 29 34 39 44 49 54 59 64 69 {
		rename `letter'`j' imagination`i'`k'
		local i = `i' + 1
	}
	local k = `k' + 1
}

/* inverse reversed coded items */
qui forvalues j = 8/13 {
	foreach i in 2 4 6 8 10 { 
	   replace extraversion`i'`j' = 6 - extraversion`i'`j' 
	   // 5 point Likert scale; reversing by calculating: 6 - original value
	}
	foreach i in 1 3 5 7 { 
	   replace agreeableness`i'`j' = 6 - agreeableness`i'`j' 
	}
	foreach i in 2 4 6 8 { 
	   replace conscientiousness`i'`j' = 6 - conscientiousness`i'`j' 
	}
	foreach i in 1 3 5 6 7 8 9 10 { 
	   replace emostability`i'`j' = 6 - emostability`i'`j' 
	}
	foreach i in 2 4 6 { 
	   replace imagination`i'`j' = 6 - imagination`i'`j' 
	}	
}

/* create mean score */
qui forvalues j = 8/13 {

	// Factor I //
	egen extraversionnonmiss`j' = rownonmiss(extraversion1`j' extraversion2`j' extraversion3`j' extraversion4`j' extraversion5`j' extraversion6`j' extraversion7`j' extraversion8`j' extraversion9`j' extraversion10`j') // number of nonmissing values
	gen extraversionscore`j' = .
	regen extraversionscore`j'  = rowmean(extraversion1`j' extraversion2`j' extraversion3`j' extraversion4`j' extraversion5`j' extraversion6`j' extraversion7`j' extraversion8`j' extraversion9`j' extraversion10`j') if extraversionnonmiss`j' >= 8, replace // create mean score if at least 8 observations
	// at least 8 obs. have to be available to create a factor score
	
	// Factor II //
	egen agreeablenessnonmiss`j' = rownonmiss(agreeableness1`j' agreeableness2`j' agreeableness3`j' agreeableness4`j' agreeableness5`j' agreeableness6`j' agreeableness7`j' agreeableness8`j' agreeableness9`j' agreeableness10`j') // number of nonmissing values
	gen agreeablenessscore`j' = .
	regen agreeablenessscore`j'  = rowmean(agreeableness1`j' agreeableness2`j' agreeableness3`j' agreeableness4`j' agreeableness5`j' agreeableness6`j' agreeableness7`j' agreeableness8`j' agreeableness9`j' agreeableness10`j') if agreeablenessnonmiss`j' >= 8, replace // create mean score if at least 8 observations
	
	// Factor III //
	egen conscientiousnessnonmiss`j' = rownonmiss(conscientiousness1`j' conscientiousness2`j' conscientiousness3`j' conscientiousness4`j' conscientiousness5`j' conscientiousness6`j' conscientiousness7`j' conscientiousness8`j' conscientiousness9`j' conscientiousness10`j') // number of nonmissing values
	gen conscientiousnessscore`j' = .
	regen conscientiousnessscore`j'  = rowmean(conscientiousness1`j' conscientiousness2`j' conscientiousness3`j' conscientiousness4`j' conscientiousness5`j' conscientiousness6`j' conscientiousness7`j' conscientiousness8`j' conscientiousness9`j' conscientiousness10`j') if conscientiousnessnonmiss`j' >= 8, replace // create mean score if at least 8 observations
	
	// Factor IV //
	egen emostabilitynonmiss`j' = rownonmiss(emostability1`j' emostability2`j' emostability3`j' emostability4`j' emostability5`j' emostability6`j' emostability7`j' emostability8`j' emostability9`j' emostability10`j') // number of nonmissing values
	gen emostabilityscore`j' = .
	regen emostabilityscore`j'  = rowmean(emostability1`j' emostability2`j' emostability3`j' emostability4`j' emostability5`j' emostability6`j' emostability7`j' emostability8`j' emostability9`j' emostability10`j') if emostabilitynonmiss`j' >= 8, replace // create mean score if at least 8 observations
	
	// Factor V //
	egen imaginationnonmiss`j' = rownonmiss(imagination1`j' imagination2`j' imagination3`j' imagination4`j' imagination5`j' imagination6`j' imagination7`j' imagination8`j' imagination9`j' imagination10`j') // number of nonmissing values
	gen imaginationscore`j' = .
	regen imaginationscore`j'  = rowmean(imagination1`j' imagination2`j' imagination3`j' imagination4`j' imagination5`j' imagination6`j' imagination7`j' imagination8`j' imagination9`j' imagination10`j') if imaginationnonmiss`j' >= 8, replace // create mean score if at least 8 observations
}


/* Example statistics for the created scores */   
alpha extraversion18 extraversion28 extraversion38 extraversion48 extraversion58 extraversion68 extraversion78 extraversion88 extraversion98 extraversion108, item
corr extraversionscore8 extraversion18 extraversion28 extraversion38 extraversion48 extraversion58 extraversion68 extraversion78 extraversion88 extraversion98 extraversion108

alpha agreeableness18 agreeableness28 agreeableness38 agreeableness48 agreeableness58 agreeableness68 agreeableness78 agreeableness88 agreeableness98 agreeableness108, item
corr agreeablenessscore8 agreeableness18 agreeableness28 agreeableness38 agreeableness48 agreeableness58 agreeableness68 agreeableness78 agreeableness88 agreeableness98 agreeableness108

alpha conscientiousness18 conscientiousness28 conscientiousness38 conscientiousness48 conscientiousness58 conscientiousness68 conscientiousness78 conscientiousness88 conscientiousness98 conscientiousness108, item
corr conscientiousnessscore8 conscientiousness18 conscientiousness28 conscientiousness38 conscientiousness48 conscientiousness58 conscientiousness68 conscientiousness78 conscientiousness88 conscientiousness98 conscientiousness108

alpha emostability18 emostability28 emostability38 emostability48 emostability58 emostability68 emostability78 emostability88 emostability98 emostability108, item
corr emostabilityscore8 emostability18 emostability28 emostability38 emostability48 emostability58 emostability68 emostability78 emostability88 emostability98 emostability108

alpha imagination18 imagination28 imagination38 imagination48 imagination58 imagination68 imagination78 imagination88 imagination98 imagination108, item
corr imaginationscore8 imagination18 imagination28 imagination38 imagination48 imagination58 imagination68 imagination78 imagination88 imagination98 imagination108


/* creation of data sets */
keep(id *score*)

////////////////////// WIDE /////////////////////////////////
stata2mplus using BIG5, replace
/////////////////////////////////////////////////////////////

////////////////////// LONG /////////////////////////////////
reshape long extraversionscore agreeablenessscore conscientiousnessscore emostabilityscore imaginationscore, i(id) j(wave) 
stata2mplus using BIG5Long, replace
/////////////////////////////////////////////////////////////

label var extraversionscore "Big5: Extraversion (1=very in-,5=accurate)" 
label var agreeablenessscore "Big5: Agreeableness (1=very in-,5=accurate)" 
label var conscientiousnessscore "Big5: Conscientiousness (1=very in-,5=accurate)" 
label var emostabilityscore "Big5: Emotional Stability (1=very in-,5=accurate)" 
label var imaginationscore "Big5: Imagination (1=very in-,5=accurate)" 

////////////// STATA FILE FOR MERGING ///////////////////////
saveold d08_b5, replace
/////////////////////////////////////////////////////////////

